require( "scripts/style.lua" );



TitleFont = {
  proportionalFont,
  24,
  BorderColor
};

InfoFont = {
  proportionalFont,
  12,
  BorderColor
};

GraphicsButtonGraphics = {
	"backgrounds/textfield",
	"backgrounds/textfield",
	"backgrounds/textfield"
};

InteractionButtonStyle =
{
	parent=DefaultStyle,
	font=InfoFont,
	graphics=CheckboxButtonGraphics,
	xoffset = 0,
	yoffset = 0,
	scale = 0.25,
	flags = kHAlignLeft + kVAlignCenter,
	w=150,
	h = 20,
	tx = 15,
	ty = 3,
	type = kRadio
};


function MakeGraphicButton( nameVal, xVal, yVal, num )
	
	return Group(
		{
			Button
			{
				font = SmallButtonFont,
				type = kPush,
				x=xVal,
				y=yVal,
				scale = 0.5,
				graphics = GraphicsButtonGraphics,
				Text
				{
					font = InfoFont,
					name = "graphicval"..num,
					x=5,y=0,w=kMax-5,h=kMax,
					length=40
				};
				command =
					function()
						returnval = DoModal("scripts/leveleditor/graphics.lua");
						if (not(returnval == nil)) then
							SetWindowText("graphicval"..num, returnval);
						end
					end
			};
			
			Text
			{
				font = InfoFont,
				name = "row"..num,
				x=xVal-10,y=yVal + 25,w=120,h=20,
				flags = kHAlignCenter + kVAlignTop,
				label = nameVal
			};
		}
	)
end


function MakeGraphicButtons( )
	local windows = {};
	myLabel = "#"..GetString("ce_graphics");
	table.insert(windows, MakeGraphicButton(myLabel, 20, 60, 0));

	
	for i=1,6 do
		myLabel = "#"..GetString("ce_graphicsover")..i;
		table.insert(windows, MakeGraphicButton(myLabel, 20 + (i * 110), 60, i));
	end;
	
	return Group(windows);
end


function MakeTextEditField( xVal, yVal, winName, labelVal )
	
	return Group(
		{
			Bitmap
			{
				image="backgrounds/textfield.png",
				x=xVal,
				y=yVal,
				scale = 0.5,
				
				TextEdit
				{
					font = InfoFont,
					name = winName,
					x=5,y=0,w=kMax-5,h=kMax,
					length=40
				};
			};
			
			Text
			{
				font = InfoFont,
				name = labelVal,
				x=xVal-10,y=yVal + 25,w=120,h=20,
				flags = kHAlignCenter + kVAlignTop,
				label = labelVal
			};
		}
	)
end

MakeDialog
{
		
		FillWindow
		{
			x=0,
			y= 0,
			w= 800,
			h = 600,
			r = 0.75,
			g = 0.75,
			b = 0.75,
			CustomerEditor
			{ 
				name="customereditorwindow",
				x=0,
				y=0,
				w=800,
				h=600,
				
				Button
				{
					x = 250,
					y = 10,
					name = "customerleft",
					graphics = LeftArrowGraphics,
					type = kPush,
					scale = 0.25,
					command = 
						function() 
							IncrementCustomer(-1, true);
						end	
				},
					
					
				Text
				{
					font = TitleFont,
					name = "customername",
					x=300,y=10,w=200,h=50,
					flags = kHAlignCenter + kVAlignTop,
					label = ""
				};
				
				Button
				{
					x = 530,
					y = 10,
					name = "customerright",
					graphics = LeftArrowGraphics,
					hflip = true,
					type = kPush,
					scale = 0.25,
					command = 
						function() 
							IncrementCustomer(1, true);
						end	
				},
				
				
				MakeGraphicButtons();
				
				MakeTextEditField(10, 150, "timemood", "#"..GetString("ce_timemood"));
				MakeTextEditField(120, 150, "colormood", "#"..GetString("ce_colormood"));
				MakeTextEditField(230, 150, "basetip", "#"..GetString("ce_basetip"));
				MakeTextEditField(340, 150, "moodtip", "#"..GetString("ce_moodtip"));
				MakeTextEditField(450, 150, "dessertmood", "#"..GetString("ce_dessertmood"));
				MakeTextEditField(560, 150, "loveeffect", "#"..GetString("ce_loveeffect"));
				MakeTextEditField(670, 150, "specialchance", "#"..GetString("ce_specialchance"));
				
				MakeTextEditField(10, 225, "spillchance", "#"..GetString("ce_spillchance"));
				MakeTextEditField(120, 225, "spilltimer", "#"..GetString("ce_spilltimer"));
				MakeTextEditField(230, 225, "noiserate", "#"..GetString("ce_noiserate"));
				MakeTextEditField(340, 225, "noiserangex", "#"..GetString("ce_noiserangex"));
				MakeTextEditField(450, 225, "noiserangey", "#"..GetString("ce_noiserangey"));
				MakeTextEditField(560, 225, "noisemood", "#"..GetString("ce_noisemood"));
				MakeTextEditField(670, 225, "noiseeffect", "#"..GetString("ce_noiseeffect"));
				
				MakeTextEditField(10, 300, "waitingmadms", "#"..GetString("ce_waitingmadms"));
				MakeTextEditField(120, 300, "decidingdurationms", "#"..GetString("ce_decidingdurationms"));
				MakeTextEditField(230, 300, "readyhappyms", "#"..GetString("ce_readyhappyms"));
				MakeTextEditField(340, 300, "readymadms", "#"..GetString("ce_readymadms"));
				MakeTextEditField(450, 300, "orderedhappyms", "#"..GetString("ce_orderedhappyms"));
				MakeTextEditField(560, 300, "orederedmadms", "#"..GetString("ce_orederedmadms"));
				MakeTextEditField(670, 300, "eatingdurationms", "#"..GetString("ce_eatingdurationms"));
				
				MakeTextEditField(10, 375, "checkhappyms", "#"..GetString("ce_checkhappyms"));
				MakeTextEditField(120, 375, "checkmadms", "#"..GetString("ce_checkmadms"));
				MakeTextEditField(230, 375, "snackhappyms", "#"..GetString("ce_snackhappyms"));
				MakeTextEditField(340, 375, "snackmadms", "#"..GetString("ce_snackmadms"));
				MakeTextEditField(450, 375, "orderdesserthappyms", "#"..GetString("ce_orderdesserthappyms"));
				MakeTextEditField(560, 375, "orderdessertmadms", "#"..GetString("ce_orderdessertmadms"));
				MakeTextEditField(670, 375, "eatingdessertdurationms", "#"..GetString("ce_eatingdessertdurationms"));
				
				MakeTextEditField(10, 450, "specialhappyms", "#"..GetString("ce_specialhappyms"));
				MakeTextEditField(120, 450, "specialmadms", "#"..GetString("ce_specialmadms"));
				MakeTextEditField(230, 450, "numMeals", "#"..GetString("ce_nummeals"));
				MakeTextEditField(340, 450, "leavePenaltyMultiplier", "#"..GetString("ce_penaltymultiplier"));
				
				
				SetStyle(InteractionButtonStyle);
				BeginGroup();
				Button{x=550,y=425,w=90,name="nonoise", label="ce_nonoise"};
				Button{x=550,y=450,w=90,name="cellphone", label="ce_cellphone"};
				Button{x=550,y=475,w=90,name="baby", label="ce_baby"};
				Button{x=550,y=500,w=90,name="smoochers", label="ce_smoochers"};
				
				Button{x=650,y=425,name="celebrity", label="ce_celebrity"};
				Button{x=650,y=450,name="boyflirt", label="ce_boyflirt"};
				Button{x=650,y=475,name="girlflirt", label="ce_girlflirt"};
				Button{x=650,y=500,name="primadonna", label="ce_primadonna"};
				
				SetStyle(DefaultStyle);


			
				Button
				{
					x=100,
					y=530,
					font = StandardButtonFont,
					graphics = SolidButtonGraphics,
					name="delete",
					label="ce_delete",
					type = kPush,
					command=
						function()
							result = DisplayDialog { 
								"scripts/yesno.lua", 
								body ="ce_deleteconfirm",
								title = "" 
							};
							if (result=='yes') then
								DeleteCustomer();
							end
						end
				},
				
				Button
				{
					x=220,
					y=530,
					font = StandardButtonFont,
					graphics = SolidButtonGraphics,
					name="new",
					label="ce_new",
					type = kPush,
					command=
						function()
							name = DoModal("scripts/leveleditor/customername.lua");
							if (not(name == nil)) then
								NewCustomer(name);
							end
						end
				},
				
			
				Button
				{
					x=670,
					y=530,
					font = StandardButtonFont,
					graphics = SolidButtonGraphics,
					name="back",
					label="back",
					type = kPush,
					command=
						function()
							IncrementCustomer(1, true);
							SwapToModalSetName(GetMainMenuScript());
						end
				},
			};
		}
	
};